<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserWithdrawalLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_withdrawal_logs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_withdraw_id')->index()->comment('用户申请提现表ID');
            $table->string('status_desc',50)->default('')->comment('提现处理状态');
            $table->string('admin_user',50)->default('')->comment('操作人名字');
            $table->string('remark',100)->default('')->comment('操作人备注');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_withdrawal_logs');
    }
}
