<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserWithdrawsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_withdraws', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->index()->comment('用户ID');
            $table->string('type',50)->default('')->comment('member为会员,supplier为商户');
            $table->integer('money')->comment('提现金额');
            $table->string('name',50)->default('')->comment('持卡人姓名');
            $table->string('number',50)->default('')->comment('银行卡卡号');
            $table->string('branch',100)->default('')->comment('支行信息');
            $table->string('phone',50)->default('')->comment('银行预留手机号');
            $table->tinyInteger('status')->comment('提现状态：0等待处理1正在处理2失败处理3成功处理');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_withdraws');
    }
}
