<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/27
 * Time: 17:44
 */
namespace Modules\Base\Transformers;

use League\Fractal\TransformerAbstract;

class BaseTransformer extends TransformerAbstract
{

    static $extraIncludes = [];
    static $extraDefaultIncludes = [];


    public function __construct()
    {
        if (!isset(static::$extraIncludes[static::class])) {
            static::$extraIncludes[static::class]=[];
        }
        if (!isset(static::$extraDefaultIncludes[static::class])) {
            static::$extraDefaultIncludes[static::class]=[];
        }

        $this->availableIncludes += static::$extraIncludes[static::class];
        $this->defaultIncludes +=static::$extraDefaultIncludes[static::class];
    }

    public static function addIncludes($name)
    {
        if (!isset(static::$extraIncludes[static::class])) {
            static::$extraIncludes[static::class]=[];
        }
        static::$extraIncludes[static::class] += (array)$name;
    }

    public static function addDefaultIncludes($name)
    {
        if (!isset(static::$extraDefaultIncludes[static::class])) {
            static::$extraDefaultIncludes[static::class]=[];
        }
        static::$extraDefaultIncludes[static::class] += (array)$name;
    }
}
