<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/15
 * Time: 9:47
 */
namespace Modules\Base\Transformers;

use Modules\Base\Entities\Activity;
use Modules\Base\Entities\Enrollment;

class ActivityTransformer extends BaseTransformer
{
    public $availableIncludes=['enrollments','enrollment'];
    /**
     * @param Activity $activity
     * @return array
     *
     * @OA\Schema(
     *     description="活动信息",
     *     type="object",
     *     schema="Activity",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="start", type="string", description="开始时间"),
     *     @OA\Property(property="end", type="string", description="开始时间"),
     *     @OA\Property(property="enroll_start", type="string", description="报名开始时间"),
     *     @OA\Property(property="enroll_end", type="string", description="报名结束时间"),
     *     @OA\Property(property="cover", type="string", description="封面图"),
     *     @OA\Property(property="price", type="string", description="价格"),
     *     @OA\Property(property="sponsor", type="string", description="主办人"),
     *     @OA\Property(property="address", type="string", description="地址"),
     *     @OA\Property(property="contact", type="string", description="联系方式"),
     *     @OA\Property(property="introduction", type="string", description="简介"),
     *     @OA\Property(property="content", type="string", description="内容"),
     *     @OA\Property(property="limit", type="number", description="数量限制"),
     *     @OA\Property(property="enrolledCount", type="number", description="报名数量"),
     *     @OA\Property(property="enrollment", type="number", description="当前用户报名信息"),
     *     @OA\Property(property="enrollments", type="number", description="最近报名信息"),
     * )
     */
    public function transform(Activity $activity)
    {
        return map_attr($activity, ['id','title', 'start', 'end', 'enroll_start', 'enroll_end', 'cover', 'price', 'sponsor', 'address', 'contact', 'content', 'limit', 'enrolledCount','introduction']);
    }

    public function includeEnrollments($activity)
    {
        return $this->collection($activity->enrollments()->orderBy('id', 'desc')->limit(15)->get(), new EnrollmentTransformer());
    }

    public function includeEnrollment($activity)
    {
        $user_id = \Auth::guard('api')->id();
        if (!$user_id) return null;
        $enrollment = $activity->enrollments()->where('user_id', $user_id)->first();
        if (!$enrollment) return null;
        return $this->item($enrollment, new EnrollmentTransformer(true));
    }
}
