<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/15
 * Time: 9:47
 */
namespace Modules\Base\Transformers;

use Illuminate\Support\Traits\Macroable;

class AccessTokenTransformer extends BaseTransformer
{
    use Macroable;

    public $availableIncludes = ['user'];

    /**
     * @OA\Schema(
     *     description="Token信息",
     *     type="object",
     *     schema="Token",
     *     @OA\Property(property="access_token", type="string", description="Token"),
     *     @OA\Property(property="token_type", type="string", description="Token类型"),
     *     @OA\Property(property="expires_in", type="integer", description="过期时间"),
     *     @OA\Property(property="user", type="object", description="用户", @OA\Property(property="data", type="object", ref="#/components/schemas/User"))
     * )
     */
    public function transform($user)
    {
        return [
            'access_token' => \Auth::guard('api')->login($user),
            'token_type' => 'Bearer',
            'expires_in' => \Auth::guard('api')->factory()->getTTL() * 60,
        ];
    }

    public function includeUser($user)
    {
        return $this->item($user, new UserTransformer());
    }
}
