<?php

$api = app('Dingo\Api\Routing\Router');

$api->version(
    'v1',
    array_merge(
        [
            'namespace' => 'Modules\Base\Http\Controllers\Api',
            'prefix' => 'api/base',
        ],
        config('api.defaultSetting', [])
    ),
    function ($api) {
        $api->get('/', 'ApiController@index')->name('api.base.home');

        // 短信验证码
        $api->post('sms', 'SmsController@store')
            ->name('api.base.sms.store');

        // 用户注册
        $api->post('users', 'UsersController@store')
            ->name('api.base.users.store');

        // 登录
        $api->post('authorizations', 'AuthorizationsController@store')
            ->name('api.base.authorizations.store');

        // 第三方账号登录
        $api->post('authorizations/openlogin/{type}', 'AuthorizationsController@openlogin')
            ->name('api.base.authorizations.openlogin');

        //短信重置密码
        $api->put('user/password', 'UsersController@password')
            ->name('api.base.user.password');

        // 需要 token 验证的接口
        $api->group(['middleware' => 'api.auth'], function ($api) {

            // 刷新token
            $api->put('authorizations/current', 'AuthorizationsController@update')
                ->name('api.base.authorizations.update');

            // 删除token
            $api->delete('authorizations/current', 'AuthorizationsController@destroy')
                ->name('api.base.authorizations.destroy');

            // 文件上传
            $api->post('files', 'FilesController@store')
                ->name('api.base.files.store');

            // 当前登录用户信息
            $api->get('user', 'UsersController@me')
                ->name('api.base.user.show');

            // 编辑登录用户信息
            $api->put('user', 'UsersController@update')
                ->name('api.base.user.update');

            // 通知列表
            $api->get('user/notifications', 'NotificationsController@index')
                ->name('api.base.user.notifications.index');

            // 查看某一条通知
            $api->get('user/notifications/{notification_id}', 'NotificationsController@show')
                ->name('api.base.user.notifications.show');

            //发送一个测试的通知消息
            $api->post('user/notifications', 'NotificationsController@test')
                ->name('api.base.user.notifications.test');

            // 通知统计
            $api->get('user/notifications/stats', 'NotificationsController@stats')
                ->name('api.base.user.notifications.stats');

            // 标记消息通知为已读
            $api->put('user/read/notifications', 'NotificationsController@read')
                ->name('api.base.user.notifications.read');
        });
    }
);



$api->version(
    'v1',
    array_merge(
        [
            'namespace' => 'Modules\Base\Http\Controllers\Api',
            'prefix' => 'api',
        ],
        config('api.defaultSetting', [])
    ),
    function ($api) {
        $api->get('/', 'ApiController@index')->name('api.base.home');

        // 最近报名用户信息
        $api->get('activities/{activity}', 'ActivityController@detail')
            ->name('api.activities.detail');

        // 最近报名用户信息
        $api->get('activities', 'ActivityController@index')
            ->name('api.activities.index');

        // 最近报名用户信息
        $api->get('enrollments', 'EnrollmentController@index')
            ->name('api.enrollments.index');

        // 需要 token 验证的接口
        $api->group(['middleware' => 'api.auth'], function ($api) {

            // 我的报名信息
            $api->get('user/enrollment', 'EnrollmentController@me')
                ->name('api.user.enrollment');

            // 我的报名信息
            $api->get('user/enrollments', 'EnrollmentController@meEnrollments')
                ->name('api.user.enrollments');

            // 报名
            $api->post('enrollments', 'EnrollmentController@store')
                ->name('api.enrollments.store');
        });
    }
);


Route::group([
    'prefix' => config('admin.route.prefix'),
    'middleware' => config('admin.route.middleware'),
    'namespace' => 'Modules\Base\Http\Controllers\Admin',
], function ($router) {
    //活动
    $router->resource('/activity', 'ActivityController');
    //报名
    $router->resource('/enrollment', 'EnrollmentController');
    $router->resource('/files', 'FilesController');

    $router->resource('/openids', 'OpenidsController');
    $router->resource('/users', 'UsersController');
});
