<?php

namespace Modules\Base\Http\Controllers\Admin;

use Modules\Base\Entities\User;
use App\Http\Controllers\Controller;
use SMG\Admin\Controllers\HasResourceActions;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;
use SMG\Admin\Show;

class UsersController extends Controller
{
    use HasResourceActions;

    /**
     * Index interface.
     *
     * @param Content $content
     * @return mixed
     */
    public function index(Content $content)
    {
        return $content
            ->header('会员')
            ->body($this->grid());
    }

    /**
     * Show interface.
     *
     * @param mixed   $id
     * @param Content $content
     * @return mixed
     */
    public function show($id, Content $content)
    {
        return $content
            ->header('详情')
            ->body($this->detail($id));
    }


    /**
     * Edit interface.
     *
     * @param mixed   $id
     * @param Content $content
     * @return mixed
     */
    public function edit($id, Content $content)
    {
        return $content
            ->header('编辑')
            ->description('description')
            ->body($this->form()->edit($id));
    }

    /**
     * Create interface.
     *
     * @param Content $content
     * @return mixed
     */
    public function create(Content $content)
    {
        return $content
            ->header('新增')
            ->body($this->form());
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::Grid(new User(), function($grid) {
            $grid->id('id')->sortable();
            $grid->id('Id');
            $grid->name('姓名');
            $grid->phone('手机号');
            $grid->avatar()->image('',60,60);
            $grid->email('邮箱');
            $grid->sex('性别')->display(function ($sex) {
                return $sex ? $sex ==1?'男':'女' : '未知';
            });
            $grid->company('公司名');
            $grid->enableFilter();
            $grid->enableFilter();
            $grid->disableExport();
            $grid->disableCreateButton();
            $grid->actions(function ($actions) {
                $actions->disableEdit();
                $actions->disableDelete();
            });
            $grid->filter(function ($filter) {
                // 去掉默认的id过滤器
                $filter->disableIdFilter();
                // 在这里添加字段过滤器
                $filter->like('name', '姓名');
                $filter->like('phone', '手机号');
            });
            $grid->created_at('添加时间');
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed   $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(User::findOrFail($id));
        $show->id('Id');
        $show->name('姓名');
        $show->phone('手机号');
        $show->email('邮箱');
        $show->avatar('头像')->image();
        $show->panel()->tools(function ($tools) {
            $tools->disableEdit();
            $tools->disableDelete();
        });
        $show->sex('性别')->using(['0' => '未知', 1 => '男' ,1 => '女' ]);
        $show->company('公司名');
        $show->created_at('创建时间');
        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new User);
        $form->text('name', '姓名')->rules('required');
        $form->mobile('phone', '手机号')->rules('required');
        $form->email('email', '邮箱')->rules(null);

        $form->saving(function (Form $form) {
            if ($form->password && $form->model()->password != $form->password) {
                $form->password = bcrypt($form->password);
            }
        });
        $form->password('password', '用户密码');
        $form->file('avatar', '头像')->rules('required');
        $form->radio('sex', '性别')->options([0=>'未知',1=>'男',2=>'女']);
        return $form;
    }
}
