<?php

namespace Modules\Base\Entities;

use Illuminate\Database\Eloquent\Model;

class Activity extends Model
{
    protected $fillable = ['title', 'start', 'end', 'enroll_start', 'enroll_end', 'sponsor', 'address', 'contact', 'content', 'cover', 'price', 'limit'];

    /**
     * 获取是否已报名
     * @return bool
     */
    public function getIsEnrolledAttribute()
    {
        $id = \Auth::id();
        if (!$id) return false;
        return Enrollment::where('user_id', $id)->where('activity_id', $this->id)->exist();
    }

    /**
     * 报信信息列表
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function enrollments()
    {
        return $this->hasMany(Enrollment::class);
    }

    public function enrollment()
    {
        return $this->hasMany(Enrollment::class);
    }

    /**
     * 报名数量
     * @return mixed
     */
    public function getEnrolledCountAttribute()
    {
        //debug_print_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS);
        return $this->enrollments()->count();
        //return Enrollment::where('activity_id', $this->id)->count();
    }
}
