<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class UpdateAdminMenuTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        \DB::table(config('admin.database.menu_table'))->where('id', 1)->update(['title' => '首页']);
        \DB::table(config('admin.database.menu_table'))->where('id', 2)->update(['title' => '后台管理']);
        \DB::table(config('admin.database.menu_table'))->where('id', 3)->update(['title' => '用户']);
        \DB::table(config('admin.database.menu_table'))->where('id', 4)->update(['title' => '角色']);
        \DB::table(config('admin.database.menu_table'))->where('id', 5)->update(['title' => '权限']);
        \DB::table(config('admin.database.menu_table'))->where('id', 6)->update(['title' => '菜单']);
        \DB::table(config('admin.database.menu_table'))->where('id', 7)->update(['title' => '操作日志']);

        try {
            \Schema::table(config('admin.database.menu_table'), function ($table) {
                $table->string('uri', 150)->nullable()->change();
                $table->unique('uri');
            });
        } catch (\Exception $e) {
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
