import myhttp from "../../utils/http.js"

var app = getApp();
var appMobile = {};
Page({

  /**
   * 页面的初始数据
   */
  data: {
    userInfo: {},
    hasUserInfo: false,
    canIUse: wx.canIUse('button.open-type.getUserInfo'),
    enrolledCount: 0,
    limit: 0,
    isEnrollment: false, //是否已经报名  
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    if (!app.globalData.isLogin) {
      app.loginReadyCallback = () => {
        this.activitieContent()
      }
    }
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {
    console.log('show')
    app.auth()

    //获取活动信息
    this.activitieContent();
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  },

  /**
   * 产品经理课程
   */
  courseContent: function() {
    if (this.data.isEnrollment) {
      wx.showToast({
        title: '已经报过名',
        duration: 2000,
        icon: 'none'
      })
      return false
    }

    if (this.data.limit > 0 && this.data.enrolledCount >= this.data.limit) {
      wx.showToast({
        title: '报名人数已满',
        duration: 2000,
        icon: 'none'
      })
      return false
    }

    var d = new Date()
    if ((new Date(this.data.enroll_start)) > d) {
      wx.showToast({
        title: '报名时间未到',
        duration: 2000,
        icon: 'none'
      })
      return false
    }

    if ((new Date(this.data.enroll_end)) < d) {
      wx.showToast({
        title: '报名时间已截止',
        duration: 2000,
        icon: 'none'
      })
      return false
    }

    wx.navigateTo({
      url: '../apply/apply'
    })
  },
  /**
   * 课程记录
   */
  enrollentRocerds: function() {
    wx.navigateTo({
      url: '../course/course'
    })
  },
  /**
   * 报名信息 
   */
  activitieContent: function() {
    var that = this;
    myhttp.HttpRequst('activities/1', {
      include: 'enrollment,enrollments'
    }, "GET", function(res) {

      if (res.statusCode == 200) {
        let data = res.data.data; //详情轮播图
        const regex = new RegExp('<img', 'gi');
        let _content = (data.content).replace(regex, '<img style="max-width: 100%;"');
        let _enrollment = data.enrollment;
        let _isEnrollment = false;

        if (_enrollment) {
          _isEnrollment = true;
        }

        that.setData({
          activitetitle: data.title,
          enrolledCount: data.enrolledCount,
          enroll_start: data.enroll_start.substring(0, 16),
          enroll_end: data.enroll_end.substring(0, 16),
          sponsor: data.sponsor,
          address: data.address,
          telphone: data.contact,
          starttime: data.start,
          start: ((data.start).split(" "))[0],
          end: ((data.end).split(" "))[0],
          contents: _content,
          enrollments: data.enrollments.data,
          isEnrollment: _isEnrollment,
          price: data.price,
          cover: data.cover ? app.globalData.imgSuffix + data.cover : null,
          limit: data.limit

        })

      } else {
        wx.showToast({
          title: res.data.errMsg,
          duration: 2000,
        });
      }
    });
  }

})