
import myhttp from "../../utils/http.js"
// pages/apply/apply.js
Page({

  /**
   * 页面的初始数据
   */
  data: {
    getSmsRequireInfo: '获取验证码',
    disabled: true,
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.getImageCode();
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
  
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
  
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {
  
  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {
  
  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
  
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {
  
  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {
  
  },
   /**
    * 获取图形验证
    */
  getImageCode: function () {

    let that = this;

    myhttp.HttpRequst('captcha/api', {}, "GET", function (res) {

      that.setData({
        imageCode: res.data.data.img,
        imageCodeKey: res.data.data.key
      })

    }, function () {
      wx.showToast({
        title: '网络异常', image: '../../images/fail@2x.png', duration: 2000
      })
    }, true);
  }, 
  /**
   * 获取短信验证
   */
  getSmsVerification: function () {
   
    var that = this;
    let phone = that.data.activePhoe;

    let captcha_code = that.data.codeImg;
    let captcha_key = that.data.imageCodeKey;

    let types = 4;//添加银行卡
    var myreg = /^(14[0-9]|13[0-9]|15[0-9]|17[0-9]|18[0-9])\d{8}$$/;
    if (phone == "") {
      wx.showToast({
        title: '手机号不能为空',
        icon: 'none',
        duration: 1000
      })
      return false;
    }
    else if (!myreg.test(phone)) {
      wx.showToast({
        title: '请输入正确的手机号',
        icon: 'none',
        duration: 1000
      })
      return false;
    }
    else if (captcha_key == "") {
      wx.showToast({
        title: '图形验证不能为空',
        icon: 'none',
        duration: 1000
      })
      return false;
    }
    else {

      myhttp.HttpRequst('base/sms', { captcha_key: captcha_key, captcha_code: captcha_code, phone: phone, type: types }, "POST", function (res) {

        if (res.statusCode == 201) {

          var num = 61;
          var timer = setInterval(function () {
            num--;
            if (num <= 0) {
              clearInterval(timer);
              that.getImageCode();
              that.setData({
                getSmsRequireInfo: '重新发送',
                code: '',
                disabled: true
              })

            } else {
              that.setData({
                getSmsRequireInfo: num + "s后重新发送",
                disabled: false
              })
            }
          }, 1000)
        }
        else if (res.statusCode == 422) {
          wx.showToast({
            title: res.data.errors.captcha_code[0],
            image: "../../images/fail@2x.png",
            duration: 2000,
          });
        }
        else {
          wx.showToast({
            title: '网络异常',
            image: "../../images/fail@2x.png",
            duration: 2000,
          });
        }

      });
    }

  },
  /**
   * 监听报名信息表单
   */
  watchName: function (event) {
    this.setData({
      activeName: event.detail.value
    })
  },
  watchPhone: function (event) {
    this.setData({
      activePhoe: event.detail.value
    })
  },
  // watchCodeImg: function (event) {
  //   this.setData({
  //     codeImg: event.detail.value
  //   })
  // },
  // watchCodeSms: function (event) {
  //   this.setData({
  //     codeSms: event.detail.value
  //   })
  // },
  watchCompany: function (event) {
    this.setData({
      company: event.detail.value
    })
  },
  watchRecommender: function (event) {
    this.setData({
      recommender: event.detail.value
    })
  },
  /**
   * 提交报名信息
   */
  submitSignups: function(){
    wx.reLaunch({
      url: '../home/home'
    })

    /*
    wx.navigateTo({
      url: '../pay/pay',
      success: function(res) {},
      fail: function(res) {},
      complete: function(res) {},
    })
    */
  },

  /**
   * 验证表单
   */
  requireForm: function(){

    var that = this;
    let _name = that.data.activeName;
    let _phone = that.data.activePhoe;
    let _code_img = that.data.codeImg;
    let _code_sms = that.data.codeSms;
    let _company = that.data.company;

    var myreg = /^(14[0-9]|13[0-9]|15[0-9]|17[0-9]|18[0-9])\d{8}$$/;
    if (!_name) {
      wx.showToast({
        title: '请输入规范姓名',
        icon: 'none',
        duration: 1000
      })
      return false;
    }
    else if (!_phone) {
      wx.showToast({
        title: '手机号不能为空',
        icon: 'none',
        duration: 1000
      })
      return false;
    }
    else if (!myreg.test(_phone)) {
      wx.showToast({
        title: '请输入正确的手机号',
        icon: 'none',
        duration: 1000
      })
      return false;
    }
    // else if (!_code_img) {
    //   wx.showToast({
    //     title: '图形验证不能为空',
    //     icon: 'none',
    //     duration: 1000
    //   })
    //   return false;
    // }
    // else if (!_code_sms) {
    //   wx.showToast({
    //     title: '短信验证不能为空',
    //     icon: 'none',
    //     duration: 1000
    //   })
    //   return false;
    // }
    else if (!_company) {
      wx.showToast({
        title: '公司名称不能为空',
        icon: 'none',
        duration: 1000
      })
      return false;
    }
    return true;
  },
 
  /***
   * 提交报名信息
   */
  submitSignUpForm: function(){

    var that = this;
    let activity_id = 1;
    let name = that.data.activeName;
    let mobile = Number(that.data.activePhoe);
    let company = that.data.company;
    let recommender = that.data.recommender ? that.data.recommender : '';

    if (that.requireForm() == false) {
      return false;
    }

    myhttp.HttpRequst('enrollments', { activity_id: activity_id, name: name, mobile: mobile, company: company, recommender: recommender }, "POST", function (res) {

      if (res.statusCode == 201) {
        //银行卡添加成功 则返回上一级银行卡列表页
        // var pages = getCurrentPages(); // 获取当前页面的页桢
        // if (pages.length > 1) {
        //   //上一个页面实例对象
        //   var prePage = pages[pages.length - 2];
        //   //关键在这里,这里面是触发上个界面
        //   prePage.changeData();
        //   wx.navigateBack({
        //     delta: 1         // 返回上一页
        //   });
        // }

        wx.showToast({
          title: '报名成功',
          image: "../../images/s@2x.png",
          duration: 2000,
        });

        that.submitSignups();
      }
      else if (res.statusCode == 422) {
        wx.showToast({
          title: res.data.errors.activity_id[0],
          image: "../images/fail@2x.png",
          duration: 2000,
        });
      }
      else {
        wx.showToast({ title: '网络故障', duration: 2000, });
      }
    });
  }
})