<?php

use Encore\Admin\Auth\Database\Menu;
use Illuminate\Database\Migrations\Migration;

class ImportMenu1010180150 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $menu = $this->createMenu('活动报名', NULL, 'fa-table', 0);
        $parent_id=$menu->id;


        $this->createMenu('活动列表', 'activity', 'fa-bars', $parent_id);
        $this->createMenu('报名列表', 'enrollment', 'fa-bars', $parent_id);

        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

    /**
     * 创建菜单
     *
     * @param $title
     * @param $uri
     * @param string $icon
     * @param int    $parentId
     *
     * @return mixed
     */
    protected function createMenu($title, $uri, $icon = 'fa-bars', $parentId = 0)
    {
        $lastOrder = Menu::max('order');

        return Menu::create([
            'parent_id' => $parentId,
            'order' => $lastOrder + 1,
            'title' => $title,
            'icon' => $icon,
            'uri' => $uri,
        ]);
    }

    /**
     * 创建权限
     *
     * @param $name
     * @param $slug
     * @param $path
     * @param null $http_method
     */
    protected function createPermission($name, $slug, $path, $http_method = null)
    {
        \Encore\Admin\Auth\Database\Permission::create([
            'name' => $name,
            'slug' => $slug,
            'http_path' => '/'.trim($path, '/'),
            'http_method' => $http_method,
        ]);
    }
}
