<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\UserWallet;

class UserWalletTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="钱包",
     *     type="object",
     *     schema="UserWallet",
     *     @OA\Property(property="user_id", type="integer", description="用户ID"),
     *     @OA\Property(property="money", type="number", description="变动值"),
     *     @OA\Property(property="pay_password", type="boolean", description="是否设置了支付密码"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(UserWallet $userWallet)
    {
        $info = $userWallet->toArray();
        $info['pay_password'] = $info['pay_password'] ? true : false;

        return $info;
    }
}
