<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\UserCoupon;

class UserCouponTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="我的优惠券",
     *     type="object",
     *     schema="UserCoupon",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="coupon_id", type="integer", description="优惠券ID"),
     *     @OA\Property(property="name", type="string", description="优惠券名称"),
     *     @OA\Property(property="config", type="object", description="优惠券配置"),
     *     @OA\Property(property="type", type="string", description="优惠券类型"),
     *     @OA\Property(property="start", type="string", description="优惠券开始使用时间"),
     *     @OA\Property(property="expired_at", type="string", description="优惠券过期时间"),
     *     @OA\Property(property="created_at", type="string", description="领取时间"),
     * )
     */
    public function transform(UserCoupon $coupon)
    {
        return map_attr($coupon->coupon, ['name', 'config', 'type', 'start'])
                + map_attr($coupon, ['id', 'coupon_id', 'status', 'expired_at', 'created_at']);
    }
}
