<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\Transport;

class TransportTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="物流公司",
     *     type="object",
     *     schema="Transport",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="name", type="string", description="名称"),
     *     @OA\Property(property="code", type="string", description="英文简称"),
     * )
     */
    public function transform(Transport $table)
    {
        return map_attr($table, [
            'id', 'name', 'code',
        ]);
    }
}
