<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\TransportExtend;

class TransportExtendTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="物流公司运费",
     *     type="object",
     *     schema="TransportExtend",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="snum", type="integer", description="首重"),
     *     @OA\Property(property="sprice", type="integer", description="首重运费"),
     *     @OA\Property(property="xnum", type="integer", description="续重"),
     *     @OA\Property(property="xprice", type="integer", description="续重运费"),
     *     @OA\Property(property="prepay", type="integer", description="运费"),
     * )
     */
    public function transform(TransportExtend $table)
    {
        return map_attr($table, [
            'id', 'snum', 'sprice', 'xnum', 'xprice', 'prepay',
        ]);
    }
}
