<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\GoodsSpec;

class GoodsSpecTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="规格",
     *     type="object",
     *     schema="Spec",
     *     @OA\Property(property="name", type="string", description="名称"),
     *     @OA\Property(property="value", type="array", @OA\Items(),  description="项"),
     * )
     *
     * @OA\Schema(
     *     description="商品规格",
     *     type="object",
     *     schema="GoodsSpec",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="spec_name", type="string", description="规格名称"),
     *     @OA\Property(property="spec_param", type="array",
     *          @OA\Items(ref="#/components/schemas/Spec"),
     *              description="规格"
     *          ),
     *     @OA\Property(property="spec_desc", type="string", description="规格描述"),
     *     @OA\Property(property="sort", type="integer", description="规格排序值"),
     *     @OA\Property(property="description", type="string", description="商品详情"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(GoodsSpec $table)
    {
        $spec_param = json_decode($table->spec_param, true);

        foreach ($spec_param as &$v) {
            $v['value'] = $v['value'] ? explode(',', $v['value']) : [];
        }

        return [
            'id' => $table->id,
            'spec_name' => $table->spec_name,
            'spec_param' => $spec_param,
            'spec_desc' => $table->spec_desc,
            'sort' => $table->sort,
            'created_at' => $table->created_at->toDateTimeString(),
            'updated_at' => $table->updated_at->toDateTimeString(),
        ];
    }
}
