<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\GoodsList;

class GoodsListTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="规格商品",
     *     type="object",
     *     schema="GoodsList",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="title", type="string", description="标题"),
     *     @OA\Property(property="spec", type="string",description="商品规格"),
     *     @OA\Property(property="market_price", type="string", description="市场价"),
     *     @OA\Property(property="selling_price", type="string", description="售价"),
     *     @OA\Property(property="goods_stock", type="string", description="库存"),
     *     @OA\Property(property="goods_sale", type="string", description="已销售数量"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(GoodsList $table)
    {
        $spec_param = json_decode($table->spec, true);

        return [
            'id' => $table->id,
            'spec' => $spec_param,
            'market_price' => $table->market_price,
            'selling_price' => $table->selling_price,
            'goods_stock' => $table->goods_stock,
            'goods_sale' => $table->goods_sale,
            'created_at' => $table->created_at->toDateTimeString(),
            'updated_at' => $table->updated_at->toDateTimeString(),
        ];
    }
}
