<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\Card;

class GoodsCategoryTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="商品分类",
     *     type="object",
     *     schema="GoodsCategory",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="parent_id", type="integer", description="父id"),
     *     @OA\Property(property="name", type="string", description="名称"),
     *     @OA\Property(property="children", type="array",
     *          @OA\Items(ref="#/components/schemas/GoodsCategory"),
     *              description="子分类列表"
     *          ),
     *     @OA\Property(property="goods", type="array",
     *          @OA\Items(ref="#/components/schemas/Goods"),
     *              description="商品列表"
     *          ),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(Card $table)
    {
        return [
            'id' => $table->id,
            'user_id' => $table->user_id,
            'org' => $table->org,
            'code' => $table->code,
            'type' => $table->type,
            'name' => $table->name,
            'number' => $table->number,
            'branch' => $table->branch,
            'phone' => $table->phone,
            'is_default' => $table->is_default,
            'created_at' => $table->created_at->toDateTimeString(),
            'updated_at' => $table->updated_at->toDateTimeString(),
        ];
    }
}
