<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\Feedback;

class FeedbackTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="客户反馈",
     *     type="object",
     *     schema="Feedback",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="user_id", type="integer", description="用户ID"),
     *     @OA\Property(property="type", type="string", description="反馈类型，前端单选文本内容"),
     *     @OA\Property(property="remark", type="string", description="反馈内容"),
     *     @OA\Property(property="status", type="integer", description="状态标记：0等待处理1正在处理2失败处理3成功处理"),
     *     @OA\Property(property="admin_user", type="string", description="操作人名字"),
     *     @OA\Property(property="reply", type="string", description="操作人答复"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(Feedback $table)
    {
        return map_attr($table, [
            'id', 'user_id', 'type', 'remark', 'status', 'admin_user', 'reply', 'created_at', 'updated_at',
        ]);
    }
}
