<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\Coupon;

class CouponTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="优惠券",
     *     type="object",
     *     schema="Coupon",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="name", type="string", description="优惠券名称"),
     *     @OA\Property(property="config", type="object", description="优惠券配置"),
     *     @OA\Property(property="type", type="string", description="优惠券类型"),
     *     @OA\Property(property="limit", type="string", description="优惠券可领用数量"),
     *     @OA\Property(property="expire_after_days", type="integer", description="优惠券领取后有效天数"),
     *     @OA\Property(property="is_collected", type="boolean", description="是否已领取"),
     *     @OA\Property(property="start", type="string", description="优惠券开始使用时间"),
     *     @OA\Property(property="end", type="string", description="优惠券结束使用时间"),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     * )
     */
    public function transform(Coupon $coupon)
    {
        $user = \Auth::guard('api')->user();

        return map_attr(
            $coupon,
            [
                'id', 'name', 'config', 'type', 'limit',  'expire_after_days','start', 'end', 'created_at',
                'is_collected' => $coupon->isCollected(optional($user)->id),
            ]
        );
    }
}
