<?php
namespace Modules\Project\Services\Order\Goods;

use Modules\Project\Entities\UserCoupon;
use Modules\Project\Services\Order\Transport\TransportCollection;
use Modules\Project\Services\OrderCouponService;

class GoodsCollection
{
    private $collection = [];

    public $coupon_id;

    public $use_coupon = false;

    public $address_id;

    public $uuid;

    protected $discount_amount = null;

    public function pushGoodsList($list)
    {
        foreach ($list as $goods) {
            $this->pushGoods($goods);
        }
    }

    public function setAddress($address_id)
    {
        $this->address_id = $address_id;
    }

    public function setCoupon($coupon_id)
    {
        $this->coupon_id = $coupon_id;
    }

    public function pushGoods($data)
    {
        $row = new GoodsRow($data);

        if (!isset($this->collection[$row->uuid()])) {
            $this->collection[$row->uuid()] = $row;
        } else {
            $this->collection[$row->uuid()]->increase($row->qty());
        }
    }

    public function goods(callable $func = null)
    {
        if ($func) {
            $res = [];

            foreach ($this->collection as $row) {
                $res[] = $func($row);
            }

            return $res;
        } else {
            return $this->collection;
        }
    }

    /**
     * 运费
     *
     * @return int|string
     */
    public function freight()
    {
        $transport_collection = new TransportCollection();

        $transport_collection->setAddress($this->address_id);

        foreach ($this->collection as $goods) {
            $transport_collection->pushTransport($goods->freight());
        }

        return $transport_collection->freight();
    }

    /**
     * 商品价格
     *
     * @return int|string
     */
    public function goods_price()
    {
        $total = 0;

        foreach ($this->collection as $goods) {
            $total = bcadd($total, $goods->total(), 2);
        }

        return $total;
    }

    public function qty()
    {
        $total = 0;

        foreach ($this->collection as $goods) {
            $total = bcadd($total, $goods->qty());
        }

        return $total;
    }

    /**
     * 优惠金额
     *
     * @return int|string
     */
    public function discount_amount()
    {
        if ($this->coupon_id) {
            $coupon_id = $this->coupon_id;

            $model = (new UserCoupon())->find($coupon_id);

            $order_coupon = new OrderCouponService($model);

            $order_coupon->setTotal($this->goods_price());

            if ($this->use_coupon) {
                if ($this->discount_amount === null) {
                    $order_coupon->setUID($this->getUUID());

                    $this->discount_amount = $order_coupon->userCoupon();
                }

                return $this->discount_amount;
            } else {
                return $order_coupon->canUseCoupon();
            }
        } else {
            return '0.00';
        }
    }

    public function getUUID()
    {
        if (!$this->uuid) {
            $this->uuid = date('YmdHis').rand(1000, 9999);
        }

        return $this->uuid;
    }

    /**
     * 应付金额
     */
    public function payable_amount()
    {
        return bcadd(bcsub($this->goods_price(), $this->discount_amount(), 2), $this->freight(), 2);
    }
}
