<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/8
 * Time: 9:26
 */
namespace Modules\Project\Services;

use Modules\Project\Entities\Card;
use Modules\Project\Entities\Distributor;
use Modules\Project\Entities\Feedback;
use Modules\Project\Entities\UserCoupon;
use Modules\Project\Entities\UserInvitation;
use Modules\Project\Entities\UserWallet;
use Modules\Project\Entities\UserWithdraw;
use Modules\Project\Transformers\DistributorTransformer;
use Modules\Project\Transformers\UserWalletTransformer;

class MacroService
{
    /**
     * 添加宏
     */
    public function addMacro()
    {
        $this->userMacro();
        $this->transformerMacro();
    }

    /**
     * 添加User关联关系
     */
    protected function userMacro()
    {
        $userClass = config('auth.providers.users.model', 'App\\User');

        //我的银行卡
        $userClass::macro('card', function () {
            return $this->hasMany(Card::class);
        });

        //我的提现记录
        $userClass::macro('withdraw', function () {
            return $this->hasMany(UserWithdraw::class);
        });

        //我的反馈
        $userClass::macro('feedback', function () {
            return $this->hasMany(Feedback::class);
        });

        //分销员
        $userClass::macro('distributor', function () {
            return $this->hasOne(Distributor::class);
        });

        //我的优惠券
        $userClass::macro('coupons', function () {
            return $this->hasMany(UserCoupon::class);
        });

        //查找我的优惠券
        $userClass::macro('getMyCoupon', function ($id, $useFailed = false) {
            $method = $useFailed ? 'findOrFail' : 'find';

            return $this->coupons()->$method($id);
        });

        //我的邀请
        $userClass::macro('invitation', function () {
            return $this->hasOne(UserInvitation::class);
        });

        //我是被谁邀请的
        $userClass::macro('parent', function () {
            if ($this->invitation == null) {
                return null;
            }

            return optional($this->invitation->parent)->user;
        });

        //我邀请的人
        $userClass::macro('children', function () {
            if ($this->invitation == null) {
                return collect();
            }

            return $this->invitation->children->map(function ($item) {
                return $item->user;
            });
        });

        //我邀请的人数量
        $userClass::macro('childrenCount', function () {
            if ($this->invitation == null) {
                return 0;
            }

            return $this->invitation->children()->count();
        });

        //我的钱包
        $userClass::macro('wallet', function () {
            return $this->hasOne(UserWallet::class)->withDefault([
                'money' => 0,
                'pay_password' => null,
            ]);
        });

        //我的钱包余额
        $userClass::macro('getMoney', function () {
            return $this->wallet->money;
        });

        //使用余额
        $userClass::macro('useMoney', function ($money, $type, $id = 0) {
            return $this->wallet->useWallet($money, $type, $id, 'money');
        });

        //增加余额
        $userClass::macro('addMoney', function ($money, $type, $id = 0) {
            return $this->wallet->addWallet($money, $type, $id, 'money');
        });

        //钱包日志
        $userClass::macro('walletLog', function ($type_id = null, $type = 'money') {
            return $this->wallet->walletLog($type_id, $type);
        });
    }

    protected function transformerMacro()
    {
        $userTransformer = \Modules\Base\Transformers\UserTransformer::class;
        $userTransformer::addIncludes(['distributor', 'wallet']);

        //是否是分销员
        $userTransformer::macro('includeDistributor', function ($user) {
            if (!$user->distributor) {
                return null;
            }

            return $this->item($user->distributor, new DistributorTransformer());
        });

        //我的钱包
        $userTransformer::macro('includeWallet', function ($user) {
            return $this->item($user->wallet, new UserWalletTransformer());
        });
    }
}
