<?php

namespace Modules\Project\Listeners;

use Modules\Project\Entities\UserWallet;
use Modules\Project\Events\OrderCompleteEvent;

class OrderCompleteListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  OrderCompleteEvent  $event
     * @return void
     */
    public function handle(OrderCompleteEvent $event)
    {
        $order = $event->order;

        $user = $order->user;

        $order_id = $order->id;

        $order_total = $order->paid_amount;

        $goods_price = $order->goods_price;

        if($parent = $user->parent()){
            $reward_money = $goods_price * db_config('order_reward_rate',0.01);

            $parent->addMoney($reward_money,UserWallet::ORDER_REWARD,$order_id);
        }
    }
}
