<?php

namespace Modules\Project\Http\Requests;

use Modules\Base\Http\Requests\BaseRequest;

class UserWithdrawRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $request = $this;

        if (!isset($this->status)) {
            $this['status'] = 0;
        }
        switch ($this->method()) {
            case 'POST':
                return [
                    'pay_password' => 'required|check_pay_password',
                    'money' => [
                        'required',
                        'regex:/^[1-9]?[0-9]+$/',
                        function ($attribute, $value, $fail) {
                            //判断用户余额
                            $user = \Auth()->user();
                            $money = $user->getMoney();

                            if (floor($value) > floor($money)) {
                                return $fail($attribute.' 提现申请失败，可用余额为'.floor($money));
                            }

                            //获取后台设置最低提现的金额
                            $withdraw_min = intval(db_config('WITHDRAW_CASH_MIN'));
                            if ($withdraw_min > 0 && intval($value) < $withdraw_min) {
                                return $fail($attribute.' 提现金额不能低于'.$withdraw_min.'元.');
                            }
                        },
                    ],
                    'card_id' => [
                        'required',
                        function ($attribute, $value, $fail) use ($request) {
                            $info = \Auth()->user()->card()->findOrFail($value);
                            $data['user_id'] = $info->user_id;
                            $request['type'] = 'member';
                            $request['name'] = $info->name;
                            $request['number'] = $info->number;
                            $request['card_id'] = $value;
                            $request['org'] = $info->org;
                            $request['code'] = $info->code;
                            $request['branch'] = $info->branch;
                            $request['phone'] = $info->phone;
                            $request['status'] = 0;
                        },
                    ],
                ];
                break;
            case 'PATCH':
                return [

                ];
                break;
        }
    }

    public function attributes()
    {
        return [
            'money' => '提现金额',
        ];
    }

    public function messages()
    {
        return [
          'money.regex' => '提现金额需要正整数',
        ];
    }
}
