<?php

namespace Modules\Project\Http\Requests;

use Modules\Base\Http\Requests\BaseRequest;

class GoodsCartRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->route('row_id')) {
            switch ($this->method()) {
                case 'PUT':
                    return [
                        'qty' => ['required','integer'],
                    ];
                    break;
            }
        }

        switch ($this->method()) {
            case 'PUT':
            case 'POST':
                return [
                    'goods' => ['required','array'],
                    'goods.*.id' => ['required','integer','min:1'],
                    //'goods.*.spec' => ['required','array'],
                    //'goods.*.spec.*.group' => ['required','string'],
                    //'goods.*.spec.*.spec_name' => ['required','string'],
                    'goods.*.qty' => ['required','integer','min:1'],
                ];
                break;
        }
    }

    public function attributes()
    {
        return [

        ];
    }

    public function messages()
    {
        return [

        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
