<?php

namespace Modules\Project\Http\Middleware;

use Illuminate\Http\Request;
use Modules\Project\Entities\OperationLog;

class LogOperation
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure                 $next
     *
     * @return mixed
     */
    public function handle(Request $request, \Closure $next)
    {
        $log = [
            'user_id' => 0,
            'path' => substr($request->path(), 0, 255),
            'method' => $request->method(),
            'ip' => $request->getClientIp(),
            'input' => json_encode([]),
        ];

        OperationLog::create($log);

        return $next($request);
    }
}
