<?php

namespace Modules\Project\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use Modules\Base\Http\Controllers\Api\ApiController;
use Modules\Project\Entities\Card;
use Modules\Project\Entities\UserWallet;
use Modules\Project\Entities\UserWithdraw;
use Modules\Project\Http\Requests\UserWithdrawRequest;
use Modules\Project\Tranaformers\UserWithdrawTransformer;

class UserWithdrawController extends ApiController
{
    /**
     * Store a newly created resource in storage.
     *
     * @param UserWithdrawRequest $request
     *
     * @return \Dingo\Api\Http\Response $response
     *
     * @OA\Post(
     *     tags={"我的钱包"},
     *     summary="提现接口",
     *     path="/api/user/withdraw",
     *     security={
     *         {"jwt_auth": {}}
     *     },
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/x-www-form-urlencoded",
     *             @OA\Schema(
     *                 type="object",
     *                 required={"money","card_id"},
     *                 @OA\Property(
     *                     property="money",
     *                     type="string"
     *                 ),
     *                 @OA\Property(
     *                     property="card_id",
     *                     type="string"
     *                 ),
     *                 @OA\Property(
     *                     property="pay_password",
     *                     type="string"
     *                 ),
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *          response="201",
     *          description="成功",
     *          @OA\MediaType(
     *              mediaType="application/json",
     *              @OA\Schema(type="object",
     *                  @OA\Property(property="data", type="object", ref="#/components/schemas/UserWithdraw")
     *              )
     *          )
     *     )
     * )
     */
    public function store(UserWithdrawRequest $request)
    {
        $this->user->card()->findOrFail($request->card_id);
        DB::beginTransaction();
        $withdraw = $this->user->withdraw()->create($request->all());
        try {
            UserWallet::get($this->user->user_id)->useWallet($withdraw->money, UserWallet::WITHDRAWAL, $withdraw->id);
        } catch (\Exception $e) {
            DB::rollback();
            $message = $e->getMessage();
            abort(500, $message);
        }

        DB::commit();

        return $this->response->item($withdraw, new UserWithdrawTransformer())
            ->setStatusCode(201);
    }

    /**
     * @return mixed
     *
     * @OA\Get(
     *     tags={"我的钱包"},
     *     summary="提现记录",
     *     path="/api/user/withdraw",
     *     security={{"jwt_auth":{}}},
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(ref="#/components/schemas/UserWithdraw"),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function index()
    {
        $lists = $this->user->withdraw()->paginate(20);

        return $this->response->paginator($lists, new UserWithdrawTransformer());
    }
}
