<?php

namespace Modules\Project\Http\Controllers\Api;

use Modules\Base\Http\Controllers\Api\ApiController;
use Modules\Project\Entities\Transport;

use Modules\Project\Http\Requests\TransportRequest;
use Modules\Project\Services\TransportService;
use Modules\Project\Tranaformers\TransportExtendTransformer;
use Modules\Project\Tranaformers\TransportTransformer;

class TransportController extends ApiController
{
    /**
     * @return mixed
     *
     * @OA\Get(
     *     tags={"快递"},
     *     summary="运费",
     *     path="/api/transport/prepay",
     *     @OA\Parameter(
     *         name="transport_id",
     *         in="query",
     *         description="运输模板id",
     *         required=true,
     *         @OA\Schema(
     *             type="integer",
     *             default=1,
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="province_id",
     *         in="query",
     *         description="省id",
     *         required=true,
     *         @OA\Schema(
     *             type="integer",
     *             default=1,
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="weight",
     *         in="query",
     *         description="good重量(kg)",
     *         required=true,
     *         @OA\Schema(
     *             type="string",
     *             default=0.9,
     *         )
     *     ),
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(ref="#/components/schemas/TransportExtend"),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function prepay(TransportRequest $request, TransportService $transportService)
    {

        //计算运费
        $transportService->prepay($request->weight, $request->transport_id, $request->province_id);

        return $this->response->item($transportService->model, new TransportExtendTransformer())
            ->setStatusCode(200);
    }

    /**
     * @return mixed
     *
     * @OA\Get(
     *     tags={"快递"},
     *     summary="支持的物流运输模板",
     *     path="/api/transport",
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(ref="#/components/schemas/Transport"),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function index()
    {
        $transport = Transport::where('id', '>', 0)->paginate(20);

        return $this->response->item($transport, new TransportTransformer())
            ->setStatusCode(200);
    }
}
