<?php

namespace Modules\Project\Http\Controllers\Api;

use Modules\Project\Http\Requests\GoodsCartRequest;
use Modules\Project\Services\GoodsCartService;

class ShoppingCartController extends \Modules\Base\Http\Controllers\Api\ApiController
{
    /**
     * 设置购物车
     *
     * @throws \ErrorException
     *
     * @return mixed
     *
     * @OA\Post(
     *     tags={"购物车"},
     *     summary="加入购物车",
     *     path="/api/shoppingcart",
     *     description="请求结构和订单相同",
     *     security={
     *         {"jwt_auth": {}}
     *     },
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\MediaType(
     *             mediaType="application/x-www-form-urlencoded",
     *             @OA\Schema(
     *                 type="object",
     *                 required={"goods"},
     *                 @OA\Property(
     *                     property="goods",
     *                     type="array",
     *                      @OA\Items(),
     *                 ),
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function add(GoodsCartRequest $request)
    {
        $goods_cart = new GoodsCartService();

        $goods_cart->_addList($request['goods']);

        $data = $goods_cart->_content();

        return $this->response->array(['data' => $data]);

        //return $this->response->noContent()->setStatusCode(201);
    }

    /**
     * 删除
     *
     * @param $row_id
     *
     * @return \Dingo\Api\Http\Response
     *
     *
     * @OA\Delete(
     *     tags={"购物车"},
     *     summary="删除",
     *     path="/api/shoppingcart/{row_id}",
     *     security={{"jwt_auth":{}}},
     *     @OA\Parameter(
     *         name="row_id",
     *         in="path",
     *         description="row_id",
     *         required=true,
     *         @OA\Schema(
     *             type="string",
     *         )
     *     ),
     *     @OA\Response(
     *          response="204",
     *          description="",
     *      )
     * )
     */
    public function remove($row_id)
    {
        $goods_cart = new GoodsCartService();

        $goods_cart->_remove($row_id);

        return $this->response->noContent();
    }

    /**
     * 删除
     *
     * @param $row_id
     *
     * @return \Dingo\Api\Http\Response
     *
     *
     * @OA\Put(
     *     tags={"购物车"},
     *     summary="更新购物车",
     *     path="/api/shoppingcart/{row_id}",
     *     security={{"jwt_auth":{}}},
     *     @OA\Parameter(
     *         name="row_id",
     *         in="path",
     *         description="row_id",
     *         required=true,
     *         @OA\Schema(
     *             type="string",
     *         )
     *     ),
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\MediaType(
     *             mediaType="application/x-www-form-urlencoded",
     *             @OA\Schema(
     *                 type="object",
     *                 required={"qty"},
     *                 @OA\Property(
     *                     property="qty",
     *                     type="string"
     *                 ),
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *          response="204",
     *          description="",
     *      )
     * )
     */
    public function update($row_id, GoodsCartRequest $request)
    {
        $goods_cart = new GoodsCartService();

        $payload = $request->only(['qty']);

        $goods_cart->_update($row_id, $payload);

        return $this->response->noContent()->setStatusCode(204);
    }

    /**
     * @throws \ErrorException
     *
     * @return mixed
     *
     * @OA\Get(
     *     tags={"购物车"},
     *     summary="获取购物车列表",
     *     path="/api/shoppingcart",
     *     security={{"jwt_auth":{}}},
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function index()
    {
        $goods_cart = new GoodsCartService();

        $data = $goods_cart->_content();

        return $this->response->array(['data' => $data]);
    }

    /**
     * 设置购物车
     *
     * @throws \ErrorException
     *
     * @return mixed
     *
     * @OA\Put(
     *     tags={"购物车"},
     *     summary="设置购物车",
     *     path="/api/shoppingcart",
     *     description="请求结构和订单相同",
     *     security={
     *         {"jwt_auth": {}}
     *     },
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\MediaType(
     *             mediaType="application/x-www-form-urlencoded",
     *             @OA\Schema(
     *                 type="object",
     *                 required={"goods"},
     *                 @OA\Property(
     *                     property="goods",
     *                     type="array",
     *                      @OA\Items(),
     *                 ),
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function setCart(GoodsCartRequest $request)
    {
        $goods_cart = new GoodsCartService();

        $goods_cart->_setList($request['goods']);

        $data = $goods_cart->_content();

        return $this->response->array(['data' => $data]);
    }
}
