<?php

namespace Modules\Project\Http\Controllers\Api;

use Modules\Base\Http\Controllers\Api\ApiController;
use Modules\Base\Tranaformers\UserTransformer;

class InvitationController extends ApiController
{
    /**
     * 我邀请的人
     *
     * @return mixed
     *
     * @OA\Get(
     *     tags={"用户"},
     *     summary="我邀请的人",
     *     path="/api/user/children",
     *     security={
     *         {"jwt_auth": {}}
     *     },
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(ref="#/components/schemas/User"),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function children()
    {
        return $this->response->collection($this->user()->children(), new UserTransformer());
    }

    /**
     * 我邀请的人
     *
     * @return mixed
     *
     * @OA\Get(
     *     tags={"用户"},
     *     summary="我邀请的人数量",
     *     path="/api/user/children_count",
     *     security={
     *         {"jwt_auth": {}}
     *     },
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="integer",
     *                      description="数量"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function childrenCount()
    {
        return $this->response->array(['data' => $this->user()->childrenCount()]);
    }

    /**
     * 邀请图片
     *
     * @return mixed
     *
     * @OA\Get(
     *     tags={"用户"},
     *     summary="邀请图片",
     *     path="/api/user/invitation_img",
     *     @OA\Parameter(
     *         name="user_id",
     *         in="query",
     *         description="用户ID",
     *         required=true,
     *         explode=true,
     *         @OA\Schema(
     *             type="integer",
     *         )
     *     ),
     *     @OA\Response(
     *      response="200",
     *      description="邀请图片",
     *      @OA\MediaType(
     *          mediaType="image/png",
     *          @OA\Schema(
     *                 type="string",
     *                 format="binary",
     *         )
     *      )
     *     )
     * )
     */
    public function img()
    {
        $user_id = request('user_id', 0);
        $page = request('page', '');
        $content = \Cache::rememberForever('invitation_user_test3_'.$user_id.'_'.md5($page), function () use ($user_id, $page) {
            //获取二维码
            $qrcode_buffer = \Cache::rememberForever('qrcode_user_3_'.$user_id.'_'.md5($page), function () use ($user_id, $page) {
                $app = app('wechat.mini_program');
                $params = ['width' => 250];
                if ($page) {
                    $params['page'] = $page;
                }
                $response = $app->app_code->getUnlimit('from_'.$user_id, $params);
                $response = $response->getBody()->getContents();
                //出错了
                if (strpos($response, 'errcode')) {
                    //如果不是PAGE参数出错导致的错误，直接抛出错误
                    throw_unless(strpos($response, 'invalid page hint'), '\Exception', $response);
                    //移去PAGE参数重新生成
                    unset($params['page']);
                    $response = $app->app_code->getUnlimit('from_'.$user_id, $params);
                    $response = $response->getBody()->getContents();
                }

                return $response;
            });

            $qrcode = \Image::make($qrcode_buffer);
            $template = resource_path('assets/img/invitation.png');
            $img = \Image::make($template)->insert($qrcode, 'center');

            return (string) $img->encode('png', 100);
        });

        return new \Illuminate\Http\Response($content, 200, [
            'Content-Type' => 'image/png',
            'Cache-Control' => 'max-age='.(config('imagecache.lifetime') * 60).', public',
        ]);
    }
}
