<?php

namespace Modules\Project\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Input;
use SMG\Categories\Models\Category;
use SMG\Slider\SliderModel;
use SMG\Slider\SliderTransformer;

class IndexController extends \Modules\Base\Http\Controllers\Api\ApiController
{
    /**
     * @OA\Get(
     *     tags={"首页"},
     *     summary="首页",
     *     path="/api/index",
     *     @OA\Parameter(
     *         name="position_code",
     *         in="query",
     *         description="position_code",
     *         required=false,
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function index()
    {
        $slider_code = Input::get('position_code', 'index_top,hot_1,hot_2,hot_3,hot_4,new_1,new_2,new_3,new_4');

        $slider_code_array = explode(',', $slider_code);

        Category::macro('slider', function () {
            return $this->morphedByMany(SliderModel::class, 'categorizable');
        });

        $list = Category::scoped([
                'categorizable_type' => SliderModel::class,
                'category_flag' => 'position',
            ])->with([
                'slider' => function ($query) {
                    $query->where('disabled', 0)->orderBy('sort', 'asc');
                },
            ])->attrWhereIn('position_code', $slider_code_array)
            ->get();

        $res = [];

        foreach ($list as $v) {
            $tmp = $v->slider;

            $sliderTransforme = new SliderTransformer();

            $tmp_array = [];

            foreach ($tmp as $slider) {
                $tmp_array[] = $sliderTransforme->transform($slider);
            }

            $res[$v->attr['position_code']] = $tmp_array;
        }

        return $this->response->array(['data' => $res]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        return view('project::create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Show the specified resource.
     *
     * @return Response
     */
    public function show()
    {
        return view('project::show');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @return Response
     */
    public function edit()
    {
        return view('project::edit');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function update(Request $request)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @return Response
     */
    public function destroy()
    {
    }
}
