<?php

namespace Modules\Project\Http\Controllers\Api;

use Modules\Project\Entities\Goods;
use Modules\Project\Tranaformers\GoodsTransformer;
use SMG\Categories\Models\Category;

class GoodsController extends \Modules\Base\Http\Controllers\Api\ApiController
{
    /**
     * @return mixed
     *
     * @OA\Get(
     *     tags={"商品"},
     *     summary="分类下商品列表",
     *     path="/api/goods",
     *     @OA\Parameter(
     *         name="category_id",
     *         in="query",
     *         description="分类id",
     *         required=false,
     *         @OA\Schema(
     *             type="integer"
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="kw",
     *         in="query",
     *         description="关键词",
     *         required=false,
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="hot",
     *         in="query",
     *         description="热门",
     *         required=false,
     *         @OA\Schema(
     *             type="integer"
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="fine",
     *         in="query",
     *         description="精品",
     *         required=false,
     *         @OA\Schema(
     *             type="integer"
     *         )
     *     ),
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(ref="#/components/schemas/Goods"),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function index()
    {
        $goods = Goods::when(request('category_id', false), function ($query, $category_id) {
            $info = Category::findOrFail($category_id);
            $query->withCategory([$info->category_flag => $category_id]);
        })->when(request('kw', false), function ($query, $kw) {
            $query->where('title', 'like', '%'.$kw.'%');
        })->when(request('hot', false), function ($query, $kw) {
            $query->where('hot',  1);
        })->when(request('fine', false), function ($query, $kw) {
            $query->where('fine',  1);
        });

        return $this->response->paginator($goods->paginate(20), (new GoodsTransformer())->is_list(true));
    }

    /**
     * @return mixed
     *
     * @OA\Get(
     *     tags={"商品"},
     *     summary="商品详情",
     *     path="/api/goods/{goods_id}",
     *     @OA\Parameter(
     *         name="goods_id",
     *         in="path",
     *         description="商品id",
     *         required=true,
     *         @OA\Schema(
     *             type="integer",
     *         )
     *     ),
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(type="object",
     *                  @OA\Property(property="data", type="object", ref="#/components/schemas/Address")
     *              )
     *          )
     *      )
     * )
     */
    public function detail($goods_id)
    {
        $goods = Goods::findOrFail($goods_id);

        return $this->response->item($goods, new GoodsTransformer());
    }
}
