<?php

namespace Modules\Project\Http\Controllers\Api;

use Modules\Base\Http\Controllers\Api\ApiController;
use Modules\Project\Http\Requests\FeedbackRequest;
use Modules\Project\Tranaformers\FeedbackTransformer;

class FeedbackController extends ApiController
{
    /**
     * @return mixed
     *
     * @OA\Post(
     *     tags={"客户反馈"},
     *     summary="提交反馈内容",
     *     path="/api/feedback",
     *     security={
     *         {"jwt_auth": {}}
     *     },
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/x-www-form-urlencoded",
     *             @OA\Schema(
     *                 type="object",
     *                 required={"type","remark"},
     *                 @OA\Property(
     *                     property="type",
     *                     type="string",
     *                     example="产品建议",
     *                 ),
     *                 @OA\Property(
     *                     property="remark",
     *                     type="string",
     *                     example="非常好用",
     *                 ),
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *          response="201",
     *          description="成功",
     *          @OA\MediaType(
     *              mediaType="application/json",
     *              @OA\Schema(type="object",
     *                  @OA\Property(property="data", type="object", ref="#/components/schemas/Feedback")
     *              )
     *          )
     *      )
     * )
     */
    public function store(FeedbackRequest $request)
    {
        $feedback = $this->user->feedback()->create($request->all());

        return $this->response->item($feedback, new FeedbackTransformer())
            ->setStatusCode(201);
    }
}
