<?php

namespace Modules\Project\Http\Controllers\Api;

use Illuminate\Http\Response;
use Modules\Base\Http\Controllers\Api\ApiController;
use Modules\Project\Http\Requests\DistributorRequest;
use Modules\Project\Services\DistributorService;
use Modules\Project\Tranaformers\DistributorTransformer;

class DistributorController extends ApiController
{
    /**
     * @return mixed
     *
     * @OA\Post(
     *     tags={"我的分销"},
     *     summary="申请分销员",
     *     path="/api/user/distributors",
     *     description="申请分销员",
     *     security={
     *         {"jwt_auth": {}}
     *     },
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/x-www-form-urlencoded",
     *             @OA\Schema(
     *                 type="object",
     *                 required={"true_name","phone","id_card_no","id_card_id","id_card_back_id"},
     *                 @OA\Property(
     *                     property="true_name",
     *                     type="string",
     *                 ),
     *                 @OA\Property(
     *                     property="id_card_no",
     *                     type="string",
     *                 ),
     *                 @OA\Property(
     *                     property="phone",
     *                     type="string",
     *                 ),
     *                 @OA\Property(
     *                     property="file_id_1",
     *                     type="integer",
     *                     description="身份证正面文件ID"
     *                 ),
     *                 @OA\Property(
     *                     property="file_id_2",
     *                     type="integer",
     *                     description="身份证反面文件ID"
     *                 ),
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *          response="201",
     *          description="成功",
     *          @OA\MediaType(
     *              mediaType="application/json",
     *              @OA\Schema(type="object",
     *                  @OA\Property(property="data", type="object", ref="#/components/schemas/Distributor")
     *              )
     *          )
     *      )
     * )
     */
    public function store(DistributorRequest $request, DistributorService $distributorService)
    {
        $distributor = $distributorService->insert($request->all());

        return $this->response->item($distributor, new DistributorTransformer())
            ->setStatusCode(201);
    }
}
