<?php
namespace Modules\Project\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Modules\Project\Entities\Transport;
use SMG\Admin\Controllers\ModelForm;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;

class TransportController extends Controller
{
    use ModelForm;

    /**
     * Index interface.
     *
     * @return Content
     */
    public function index()
    {
        return Admin::content(function (Content $content) {
            $content->header('运输模板');
            $content->description('说明');

            $content->body($this->grid());
        });

        return;
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::grid(Transport::class, function (Grid $grid) {
            $grid->id('ID')->sortable();
            $grid->name('运输模板名称');
            $grid->code('英文简称');

            $grid->created_at();
            $grid->updated_at();
        });
    }

    public function transform()
    {
        return Admin::form(Transport::class, function (Form $form) {
            $form->html($this->withlog()->render());
        });
    }

    /**
     * Edit interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function edit($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('编辑');
            $content->description('说明');

            $content->body($this->form()->edit($id));
        });
    }

    /**
     * Create interface.
     *
     * @return Content
     */
    public function create()
    {
        return Admin::content(function (Content $content) {
            $content->header('创建');
            $content->description('说明');

            $content->body($this->form());
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Admin::form(Transport::class, function (Form $form) {
            $form->display('id', 'ID');
            $form->text('name', '运输模板名称')->rules('required');
            $form->text('code', '英文简称')->rules('required');
        });
    }
}
