<?php
namespace Modules\Project\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Modules\Project\Entities\Express;
use SMG\Admin\Controllers\ModelForm;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;

class ExpressController extends Controller
{
    use ModelForm;

    /**
     * Index interface.
     *
     * @return Content
     */
    public function index()
    {
        return Admin::content(function (Content $content) {
            $content->header('快递公司');
            $content->description('说明');

            $content->body($this->grid());
        });

        return;
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::grid(Express::class, function (Grid $grid) {
            $grid->id('ID')->sortable();
            $grid->name('物流公司');
            $grid->code('英文简称');

            $grid->column('logo')->display(function () {
                $src = 'http://cdn.ickd.cn/www/images/logo/'.$this->code.'.jpg';
                $body = base64_encode(file_get_contents($src));

                return '<img src="data:image/jpg;base64,'.$body.'" />';
            });

            $grid->created_at();
            $grid->updated_at();
        });
    }

    /**
     * Edit interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function edit($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('编辑');
            $content->description('说明');

            $content->body($this->form()->edit($id));
        });
    }

    /**
     * Create interface.
     *
     * @return Content
     */
    public function create()
    {
        return Admin::content(function (Content $content) {
            $content->header('创建');
            $content->description('说明');

            $content->body($this->form());
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        Admin::addJs('/vendor/layer/layer.js');

        return Admin::form(Express::class, function (Form $form) {
            $js = '';
            $id = request()->route('express');
            if ($id) {
                $row = $form->model()->find($id);
                $js = "
                    showCompany('$row->code');
                ";
            }

            $form->display('id', 'ID');
            $form->text('code', '输入物流快递编码')->rules('required');
            $form->hidden('logo');
            $form->hidden('telephone');
            $form->hidden('name');
            $form->html('<div id="exp-info" class="form-control-static"></div>', '物流信息');
            //$form->html('<div id="express-info" class="form-control-static"></div>','常用物流公司');

            Admin::addJs('/js/admin/express.js', $js);
        });
    }
}
