<?php

namespace Modules\Project\Extensions;

use Encore\Admin\Grid;
use Encore\Admin\Grid\Exporters\AbstractExporter;
use Maatwebsite\Excel\Classes\LaravelExcelWorksheet;
use Maatwebsite\Excel\Facades\Excel;
use Modules\Project\Entities\Order;

class OrderExcelExpoter extends AbstractExporter
{

    public function export()
    {
        Excel::create('订单', function($excel) {

            $excel->sheet('订单', function(LaravelExcelWorksheet $sheet) {

                $data = $this->getData(false);

                $data->load('address');

                // 这段逻辑是从表格数据中取出需要导出的字段
                $rows = $data->map(function ($item) {

                    $data = [
                        'art_no' => [],
                        'title' => [],
                        'spec' => [],
                        //'qty' => [],
                    ];

                    $qty = 0;

                    foreach($item->orderGoods as $v){

                        $art_no = $v['goods']['attr']['art_no'] ?? '无编号';
                        $title = $v['goods_title'] ?? '无标题';

                        $data['art_no'][] = $art_no;

                        $data['title'][] = $title;

                        $spec = '';
                        if(isset($v['spec'])){
                            $tmp = json_decode($v['spec'],true);
                            foreach($tmp as $tv){
                                $spec = $spec . $tv['group'] .':'. $tv['spec_name'].' ';
                            }
                        }else{
                            $spec = '无规格';
                        }
                        $data['spec'][] = $title . '-' .$art_no .'['. $spec .']'. '×' . $v['qty'] .'件';

                        //$data['qty'][] = $v['qty'] ?? '无数量';
                        $qty = $qty + $v['qty'] ;
                    }

                    $status = [
                        Order::STATUS_DEFAULT => '待支付',
                        Order::STATUS_CANCEL => '已取消',
                        Order::STATUS_PAID => '已支付',
                        Order::STATUS_SHIPPED => '已发货',
                        Order::STATUS_CONFIRM => '确认收货',
                        Order::STATUS_COMPLETE => '已完成',
                    ];

                    $res = [
                        'created_at' => $item->created_at,
                        'order_no' => $item->order_no,
                        'paid_amount' => $item->paid_amount,
                        'name' => $item->address->name,
                        'mobile' => $item->address->mobile,
                        'area' => $item->address->area->getArea(),
                        'detail' => $item->address->detail,
                        'qty'=>$qty,
                        'status'=>$status[$item->status],
                    ];

                    foreach($data as $key=>$v){
                        $res[$key] = join( "\n" ,$v);
                    }

                    return $res;
                });



                $rows->prepend([
                    '订单时间',
                    '订单编号',
                    '支付金额',
                    '收件人',
                    '手机号',
                    '城市',
                    '地址详情',
                    '数量',
                    '状态',
                    '货号',
                    '标题',
                    '商品 （标题-货号[规格]×数量）',
                ]);

                $sheet->rows($rows,true);

                $this->setWarpText($rows,$sheet);

            });

        })->export('xlsx');
    }

    protected function setWarpText($rows, $sheet, $flag = true)
    {
        $start = 1;

        foreach($rows as $row){

            $column = 'A';

            foreach($row as $v){

                $sheet->getStyle("{$column}{$start}")->getAlignment()->setWrapText($flag);

                $column  ++;

            }

            $start ++ ;

        }
    }
}