<?php

namespace Modules\Project\Entities;

use Modules\Base\Entities\BaseModel;

class UserWithdrawalLog extends BaseModel
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_withdraw_id', 'status_desc', 'admin_user', 'remark',
    ];

    /**
     * Settings constructor.
     *
     * @param array $attributes
     */
    public function __construct($attributes = [])
    {
        parent::__construct($attributes);

        $this->setConnection(config('admin.database.connection') ?: config('database.default'));

        $this->setTable('user_withdrawal_logs');
    }
}
