<?php

namespace Modules\Project\Entities;

use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Base\Entities\BaseModel;
use Modules\Base\Entities\User;

class UserWithdraw extends BaseModel
{
    use SoftDeletes;

    const SUCCESS = 1;

    public static $lockStatus = ['1','2'];

    public static $arrStatus = ['0' => '提现中','1' => '提现失败','2' => '提现成功'];

    public static $arrType = ['member' => '会员','supplier' => '商户'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id', 'type', 'money', 'name', 'number', 'branch', 'phone', 'status', 'card_id', 'code', 'org'
    ];

    protected $dates = ['delete_at'];

    /**
     * 用户
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    /**
     * 申请处理日志
     */
    public function logs()
    {
        return $this->hasMany(UserWithdrawalLog::class, 'user_withdraw_id', 'id');
    }

    /**
     * 银行卡信息
     */
    public function bank()
    {
        return $this->belongsTo(Bank::class, 'code', 'code');
    }
}
