<?php

namespace Modules\Project\Entities;

use Illuminate\Database\Eloquent\Model;
use Kalnoy\Nestedset\NodeTrait;

class UserInvitation extends Model
{
    use NodeTrait;

    protected $primaryKey = 'user_id';
    public $incrementing = false;
    protected $fillable = ['user_id', 'parent_id'];

    public function user()
    {
        $userClass = config('auth.providers.users.model', 'App\\User');

        return $this->belongsTo($userClass);
    }
}
