<?php

namespace Modules\Project\Entities;

use Illuminate\Database\Eloquent\Model;
use SMG\Area\AreaModel;

class TransportExtendArea extends Model
{
    protected $fillable = [
        'transport_extend_id', 'province_id', 'transport_id',
    ];

    /**
     * 快递模板
     */
    public function transportExtend()
    {
        return $this->belongsTo(TransportExtend::class);
    }

    /**
     * 省
     */
    public function provinceArea()
    {
        return $this->belongsTo(AreaModel::class, 'province_id', 'id');
    }
}
