<?php

namespace Modules\Project\Entities;

use Illuminate\Database\Eloquent\Model;

class TransportExtend extends Model
{
    protected $fillable = [
        'transport_id', 'area_id', 'top_area_id', 'area_name', 'snum', 'sprice', 'xnum', 'xprice',
    ];

    /**
     * 快递公司
     */
    public function transport()
    {
        return $this->belongsTo(Transport::class);
    }

    /**
     * 快递模板关联省
     */
    public function extendAreas()
    {
        return $this->hasMany(TransportExtendArea::class, 'transport_extend_id', 'id');
    }
}
