<?php

namespace Modules\Project\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\Base\Entities\User;

class Distributor extends Model
{
    public static $arrStatus = ['0' => '等待处理','1' => '成功处理','2' => '失败处理'];

    public static $lockStatus = ['1','2'];

    protected $fillable = [
        'user_id', 'id_type', 'type', 'true_name', 'phone', 'id_card_no', 'id_card', 'id_card_back', 'status',
    ];

    /**
     * 用户
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * {@inheritdoc}
     */
    protected static function boot()
    {
        parent::boot();
        static::updating(function (self $model) {
            $row = self::find($model->id);
            if (in_array($row->status, self::$lockStatus)) {
                unset($model->status);
            }
        });
    }
}
