<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldCardIdAndCodeAndOrgToUserWithdrawsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_withdraws', function (Blueprint $table) {
            //
            $table->integer('card_id')->nullable()->comment("我的银行卡id");
            $table->string('code',20)->default('')->comment("银行编码");
            $table->string('org',30)->default('')->comment("归属行");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_withdraws', function (Blueprint $table) {
            $table->dropColumn('card_id');
            $table->dropColumn('code');
            $table->dropColumn('org');
        });
    }
}
