<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->increments('id');

            $table->string('name', 50)->comment('名称');
            $table->json('config')->comment('配置');
            $table->string('type', '150')->comment('类型');
            $table->json('rules')->nullable()->comment('规则');
            $table->tinyInteger('disabled')->default(0)->comment('是否禁用');
            $table->integer('limit')->default(1)->comment('领取数量');
            $table->timestamp('start')->nullable()->comment('开始日期');
            $table->timestamp('end')->nullable()->comment('结束日期');
            $table->tinyInteger('expire_after_days')->default(0)->comment('领取后多少天失败');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
    }
}
