<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderGoodsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_goods', function (Blueprint $table) {
            $table->increments('id');
			$table->unsignedInteger('order_id')->comment('订单id');
			$table->unsignedInteger('goods_id')->comment('商品id');
			$table->string('goods_title')->comment('商品名称');
			$table->json('spec')->nullable()->comment('规格');
			$table->unsignedInteger('qty')->comment('商品数量');
			$table->decimal('selling_price',10,2)->comment('售价');
			$table->decimal('total_price',10,2)->comment('总价格');
			$table->string('remarks')->comment('商品备注');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_goods');
    }
}
