<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFeedbackTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('feedback', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->index()->comment('用户ID');
            $table->string('type',50)->default('')->comment('反馈类型，前端单选文本内容');
            $table->string('remark',250)->default('')->comment('反馈内容');
            $table->tinyInteger('status')->comment('状态标记：0等待处理1正在处理2失败处理3成功处理');
            $table->string('admin_user',50)->default('')->comment('操作人名字');
            $table->string('reply',250)->default('')->comment('操作人答复');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('feedback');
    }
}
