<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cards', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->index()->comment('用户ID');
            $table->string('org',50)->default('')->comment('银行卡发卡机构');
            $table->string('code',50)->default('')->comment('银行英文简称');
            $table->string('type',50)->default('')->comment('DC为储蓄卡,CC为信用卡');
            $table->string('name',50)->default('')->comment('持卡人姓名');
            $table->string('number',50)->default('')->comment('银行卡卡号');
            $table->string('branch',100)->default('')->comment('支行信息');
            $table->string('phone',50)->default('')->comment('银行预留手机号');
            $table->tinyInteger('is_default')->comment('是否是默认：0不是1是');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cards');
    }
}
