<?php

/**
 *
 * @OA\Get(
 *     tags={"幻灯片"},
 *     summary="获取指定位置幻灯片",
 *     path="/api/package/sliders",
 *     description="id需要到后台查看",
 *     @OA\Parameter(
 *         name="position_id",
 *         in="query",
 *         description="位置id",
 *         required=true,
 *         @OA\Schema(
 *             type="integer"
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="成功",
 *          @OA\MediaType(
 *             mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(
 *                      property="data",
 *                      type="array",
 *                      @OA\Items(ref="#/components/schemas/Slider"),
 *                      description="列表"
 *                  ),
 *              )
 *          )
 *      )
 * )
 */

/**
 *
 * @OA\Schema(
 *     description="幻灯片图片信息",
 *     type="object",
 *     schema="Slider",
 *     @OA\Property(property="id", type="integer", description="ID"),
 *     @OA\Property(property="path", type="string", description="文件地址"),
 *     @OA\Property(property="click_event_type", type="string", description="事件类型"),
 *     @OA\Property(property="click_event_value", type="string", description="事件具体值"),
 *     @OA\Property(property="description", type="string", description="描述"),
 *     @OA\Property(property="position_id", type="integer", description="位置id"),
 *     @OA\Property(property="sort", type="integer", description="排序值"),
 * )
 */